@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())

<div class="container">
    <style>
        .numero-cadre {
            display: inline-block;
            width: 25px;
            height: 25px;
            line-height: 25px;
            margin-right: 5px;
            text-align: center;
            border-radius: 5px;
            font-family: Arial, sans-serif;
            font-weight: bold;
            font-size: 12px;
            color: #ffffff;
            background-color: #d82b2a;
            vertical-align: middle;
        }
    </style>
    
    <form action="{{ route('auberges.update', $auberge->id) }}" method="POST" enctype="multipart/form-data" lang="ar">
        @csrf
        @method('PUT')  {{-- Important pour update --}}
        
        <h3 class="mb-4 text-center"> تعديل معلومات مركب أو مركز إقامة </h3>
        <h4 class="mt-3">المعطيات</h4>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> الإسم <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input name="nom" type="text" class="form-control" required 
                    value="{{ old('nom', $auberge->nom) }}">
            </div>

            <label class="col-sm-2 col-form-label"> الصبغة </label>
            <div class="col-sm-4">
                <select name="epa" class="form-control" required>
                    <option value="">-- اختر الصبغة --</option>
                    <option value="EPA" {{ old('epa', $auberge->epa) == 'EPA' ? 'selected' : '' }}>EPA</option>
                    <option value="Non EPA" {{ old('epa', $auberge->epa) == 'Non EPA' ? 'selected' : '' }}>Non EPA</option>
                </select>
            </div>
        </div>

        <div class="form-group mt-3">
            <label for="description" class="col-sm-6 col-form-label"> تعريف المركز <span class="text-danger">*</span> </label>
            <textarea name="description" placeholder="" id="description" class="form-control" rows="4"> {{ old('description', $auberge->description ?? '') }}</textarea>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">خط العرض (Latitude)<span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="latitude" class="form-control"
                    value="{{ old('latitude', $auberge->latitude ?? '') }}"
                    placeholder="مثلاً: 36.8065">
            </div>

            <label class="col-sm-2 col-form-label">خط الطول (Longitude)<span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="longitude" class="form-control"
                    value="{{ old('longitude', $auberge->longitude ?? '') }}"
                    placeholder="مثلاً: 10.1815">
            </div>
        </div>


        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> الوسط الذي توجد به المؤسسة </label>
            <div class="col-sm-4">
                <select name="id_milieu_auberge" class="form-control" required>
                    <option value="">-- اختر الوسط --</option>
                    @foreach($milieux as $milieu)
                        <option value="{{ $milieu->id_type }}" {{ old('id_milieu_auberge', $auberge->id_milieu_auberge) == $milieu->id_type ? 'selected' : '' }}>
                            {{ $milieu->type_ar }}
                        </option>
                    @endforeach
                </select>
            </div>

            <label class="col-sm-2 col-form-label"> الإحداثيات </label>
            <div class="col-sm-4">
                <input type="text" name="coordonnees" class="form-control" 
                    value="{{ old('coordonnees', $auberge->coordonnees) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> العنوان <span class="text-danger">*</span> </label>
            <div class="col-sm-4">
                <input type="text" name="adresse" class="form-control" 
                    value="{{ old('adresse', $auberge->adresse) }}">
            </div>

            <label class="col-sm-2 col-form-label"> الترقيم البريدي <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="code_postal" class="form-control" 
                   value="{{ old('code_postal', $auberge->code_postal) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> الولاية <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                    <option value="" disabled>اختر...</option>
                        @foreach($gouvernorats as $gouv)
                            <option value="{{ $gouv->id_gouver }}" {{ old('gouvernorat_id', $auberge->gouver_id) == $gouv->id_gouver ? 'selected' : '' }}>
                                {{ $gouv->nom_ar }}
                            </option>
                        @endforeach
                </select>
            </div>
            
            
            <label class="col-sm-2 col-form-label"> المعتمدية <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                    <select required class="form-control" id="delegation_id" name="delegation_id" {{ $auberge->delegation_id ? '' : 'disabled' }}>
                        <option value="" disabled {{ old('delegation_id', $auberge->delegation_id ?? '') ? '' : 'selected' }}>اختر...</option>
                        @if($auberge->delegation_id)
                            @foreach($delegations as $del)
                                <option value="{{ $del->id_delegation }}"
                                    {{ old('delegation_id', $auberge->delegation_id ?? '') == $del->id_delegation ? 'selected' : '' }}>
                                    {{ $del->nom_ar }}
                                </option>
                            @endforeach
                        @endif
                    </select>
                </div>
        </div>

        {{-- Les autres champs sont similaires au create.blade mais avec old() ou $auberge->value --}}
        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> الهاتف القار <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="contact_tel" class="form-control" 
                    value="{{ old('contact_tel', $auberge->contact_tel) }}">
            </div>

            <label class="col-sm-2 col-form-label"> الفاكس <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="fax" class="form-control" 
                   value="{{ old('fax', $auberge->fax) }}">
            </div>
        </div>

        <div class="row mt-3 text-end align-items-start">
            <label class="col-sm-2 col-form-label">
                البريد الإلكتروني للمؤسسة <span class="text-danger">*</span>
            </label>
            <div class="col-sm-4">
                <input type="email" 
                    name="contact_email" 
                    class="form-control" 
                    value="{{ old('contact_email', $auberge->contact_email ?? '') }}">
            </div>

            <label for="image" class="col-sm-2 col-form-label">
                صورة المركب <span class="text-danger">*</span>
            </label>
            <div class="col-sm-4">
                <input type="file" name="image" id="image" class="form-control" accept="image/*">

                @if(!empty($auberge->image))
                    <div class="mt-2 text-center">
                        <img  src="{{ asset('storage/'.$auberge->image) }}"
                            alt="الصورة الحالية"
                            style="max-width: 200px; max-height: 150px; border-radius: 8px; object-fit: cover; box-shadow: 0 2px 5px rgba(0,0,0,0.1);">
                    </div>
                @endif
            </div>
        </div>


        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">سعر الليلة (سرير) <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="number" name="prix_lit" class="form-control" 
                    value="{{ old('prix_lit', $auberge->prix_lit ?? '') }}" step="0.01" min="0">
            </div>
        </div>
        

        <div class="form-group mt-3">
            
        </div>

        <h4 class="mt-3"> مدير المؤسسة </h4>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">  الإسم واللقب <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="nom_directeur" class="form-control"
                    value="{{ old('nom_directeur', $auberge->nom_directeur) }}">
            </div>

            <label class="col-sm-2 col-form-label"> الهاتف الجوال <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="tel_directeur" class="form-control"
                    value="{{ old('tel_directeur', $auberge->tel_directeur) }}">
            </div>
        </div>

        <h4 class="mt-3"> الخدمات</h4>
        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> هل يوجد فضاء للمشروبات ؟ </label>
            <div class="col-sm-4">
                <select name="espace_boisson" id="espace_boisson" class="form-control" required>
                    <option value="" disabled {{ old('espace_boisson', $auberge->espace_boisson) === null ? 'selected' : '' }}>اختر...</option>
                    <option value="1" {{ old('espace_boisson', $auberge->espace_boisson) == 1 ? 'selected' : '' }}>نعم</option>
                    <option value="0" {{ old('espace_boisson', $auberge->espace_boisson) == 0 ? 'selected' : '' }}>لا</option>
                </select>
            </div>
            
            <label class="col-sm-2 col-form-label"> مسبح  <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <select name="piscine" class="form-control" required>
                    <option value="" disabled {{ old('piscine', $auberge->piscine) === null ? 'selected' : '' }}>اختر...</option>
                    <option value="1" {{ old('piscine', $auberge->piscine) == 1 ? 'selected' : '' }}>نعم</option>
                    <option value="0" {{ old('piscine', $auberge->piscine) == 0 ? 'selected' : '' }}>لا</option>
                </select>
            </div>
        </div>

        <div class="form-group mt-3">
            <label class="col-form-label fw-bold">الفضاءات المتوفرة</label>

            <div class="form-check">
                <input class="form-check-input" type="checkbox" name="espace_tv_web" id="espace_tv_web" value="1"
                    {{ old('espace_tv_web', $auberge->espace_tv_web) == 1 ? 'checked' : '' }}>
                <label class="col-sm-4 col-form-label" for="espace_tv_web">
                    فضاء تلفزة واب
                </label>
            </div>

            <div class="form-check">
                <input class="form-check-input" type="checkbox" name="espace_radio_web" id="espace_radio_web" value="1"
                    {{ old('espace_radio_web', $auberge->espace_radio_web) == 1 ? 'checked' : '' }}>
                <label class="col-sm-4 col-form-label" for="espace_radio_web">
                    فضاء راديو واب
                </label>
            </div>

            <div class="form-check">
                <input class="form-check-input" type="checkbox" name="espace_gaming" id="espace_gaming" value="1"
                    {{ old('espace_gaming', $auberge->espace_gaming) == 1 ? 'checked' : '' }}>
                <label class="col-sm-4 col-form-label" for="espace_gaming">
                    فضاء ألعاب إلكترونية
                </label>
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            طاقة الإستيعاب تحت المباني <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="number" name="capacite_batiment" class="form-control" 
                    value="{{ old('capacite_batiment', $auberge->capacite_batiment) }}">
            </div>

            <label class="col-sm-2 col-form-label">
                عدد الغرف <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres" class="form-control" 
                    value="{{ old('nb_chambres', $auberge->nb_chambres) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            عدد الغرف الفردية</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_single" class="form-control" 
                    value="{{ old('nb_chambres_single', $auberge->nb_chambres_single) }}">
            </div>

            <label class="col-sm-2 col-form-label">
                عدد الغرف ثنائي</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_double" class="form-control" 
                    value="{{ old('nb_chambres_double', $auberge->nb_chambres_double) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            عدد الغرف ثلاثي</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_triple" class="form-control" 
                    value="{{ old('nb_chambres_triple', $auberge->nb_chambres_triple) }}">
            </div>

            <label class="col-sm-2 col-form-label">
                عدد الغرف رباعي</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_quadra" class="form-control" 
                    value="{{ old('nb_chambres_quadra', $auberge->nb_chambres_quadra) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            عدد الغرف أكثر من رباعي</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_plus" class="form-control" 
                    value="{{ old('nb_chambres_plus', $auberge->nb_chambres_plus) }}">
            </div>

            <label class="col-sm-2 col-form-label">
                عدد الوحدات الصحية داخل الغرف</label>
            <div class="col-sm-4">
                <input type="number" name="nb_salles_de_bain" class="form-control" 
                    value="{{ old('nb_salles_de_bain', $auberge->nb_salles_de_bain) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            عدد الوحدات الصحية المشتركة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_salles_de_bain_comm" class="form-control" 
                    value="{{ old('nb_salles_de_bain_comm', $auberge->nb_salles_de_bain_comm) }}">
            </div>
            <label class="col-sm-2 col-form-label">
            عدد الغرف التي تحتوي على تلفاز</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_tv" class="form-control" 
                    value="{{ old('nb_chambres_tv', $auberge->nb_chambres_tv) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            عدد الغرف المكيفة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_clim" class="form-control" 
                    value="{{ old('nb_chambres_clim', $auberge->nb_chambres_clim) }}">
            </div>
            <label class="col-sm-2 col-form-label">
            عدد الغرف التي تحتوي على ثلاجة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_frigo" class="form-control" 
                    value="{{ old('nb_chambres_frigo', $auberge->nb_chambres_frigo) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            طاقة الإستيعاب تحت الخيام إن وجدت</label>
            <div class="col-sm-4">
                <input type="number" name="capacite_tentes" class="form-control" 
                    value="{{ old('capacite_tentes', $auberge->capacite_tentes) }}">
            </div>
            <label for="cuisine_fonctionnelle" class="col-sm-2 col-form-label">المطبخ وظيفي</label>
            <div class="col-sm-4">
                <select name="cuisine_fonctionnelle" id="cuisine_fonctionnelle" class="form-control">
                    <option value="" disabled>اختر...</option>
                    <option value="1" {{ old('cuisine_fonctionnelle', $auberge->cuisine_fonctionnelle) == '1' ? 'selected' : '' }}>نعم</option>
                    <option value="0" {{ old('cuisine_fonctionnelle', $auberge->cuisine_fonctionnelle) == '0' ? 'selected' : '' }}>لا</option>
                </select>
            </div>
        </div>


        {{-- Services et sports --}}
        <div class="form-group mt-3">
            <label class="col-sm-2 col-form-label">الملاعب الرياضية</label>
            @foreach($sports as $sport)
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="sports[]" id="sport_{{ $sport->id_sport }}" value="{{ $sport->id_sport }}"
                        {{ in_array($sport->id_sport, old('sports', $auberge->sports->pluck('id_sport')->toArray())) ? 'checked' : '' }}>
                    <label class="col-sm-4 col-form-label" for="sport_{{ $sport->id_sport }}">
                        {{ $sport->nom_ar }} 
                    </label>
                </div>
            @endforeach
        </div>

        <div class="form-group mt-3">
            <label class="col-sm-6 col-form-label">الخدمات المقدمة من طرف المؤسسة</label>
            @foreach($services as $service)
                <div class="form-check">
                    <input class="form-check-input" type="checkbox" name="services[]" id="service_{{ $service->id_service }}" value="{{ $service->id_service }}"
                        {{ in_array($service->id_service, old('services', $auberge->services->pluck('id_service')->toArray())) ? 'checked' : '' }}>
                    <label class="col-sm-2 col-form-label" for="service_{{ $service->id_service }}">
                        {{ $service->nom_ar }}
                    </label>
                </div>
            @endforeach
        </div>

        <div class="form-group row mt-4">
            <h5 class="text-center mb-3">🍽️ قسم خدمات المطعم</h5>

            <table id="restauration-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإسم بالعربية</th>
                        <th>الإسم بالفرنسية</th>
                        <th>الإسم بالإنجليزية</th>
                        <th>الوصف بالعربية</th>
                        <th>الوصف بالفرنسية</th>
                        <th>الوصف بالإنجليزية</th>
                        <th>التعريفة (د.ت)</th>
                        <th>إجراء</th>
                    </tr>
                </thead>
                <tbody id="restauration-body">
                    @php $index = 0; @endphp
                    @foreach($auberge->restaurations as $restauration)
                        <tr>
                            <td data-label="الإسم بالعربية">
                                <input type="text" name="restaurations[{{ $index }}][nom_ar]" class="form-control" value="{{ $restauration->nom_ar }}" required>
                            </td>
                            <td data-label="الإسم بالفرنسية">
                                <input type="text" name="restaurations[{{ $index }}][nom_fr]" class="form-control" value="{{ $restauration->nom_fr }}" required>
                            </td>
                            <td data-label="الإسم بالإنجليزية">
                                <input type="text" name="restaurations[{{ $index }}][nom_en]" class="form-control" value="{{ $restauration->nom_en }}" required>
                            </td>
                            <td data-label="الوصف بالعربية">
                                <textarea name="restaurations[{{ $index }}][description_ar]" class="form-control" rows="1">{{ $restauration->description_ar }}</textarea>
                            </td>
                            <td data-label="الوصف بالفرنسية">
                                <textarea name="restaurations[{{ $index }}][description_fr]" class="form-control" rows="1">{{ $restauration->description_fr }}</textarea>
                            </td>
                            <td data-label="الوصف بالإنجليزية">
                                <textarea name="restaurations[{{ $index }}][description_en]" class="form-control" rows="1">{{ $restauration->description_en }}</textarea>
                            </td>
                            <td data-label="التعريفة">
                                <input type="number" step="0.01" name="restaurations[{{ $index }}][tarif]" class="form-control" value="{{ $restauration->tarif }}" required>
                            </td>
                            <td class="action-buttons">
                                <button type="button" class="btn btn-danger btn-sm" onclick="removeRestaurationRow(this)">حذف</button>
                            </td>
                        </tr>
                        @php $index++; @endphp
                    @endforeach
                </tbody>
            </table>

            <button type="button" class="btn btn-success mt-2" onclick="addRestaurationRow()">
                إضافة خدمة جديدة
            </button>
        </div>


        <div class="form-group mt-3">
            <label for="lieux_culturels" class="col-sm-6 col-form-label">المعالم الأثرية والمتاحف والفضاءات الثقافية المجاورة للمؤسسة</label>
            <textarea name="lieux_culturels" id="lieux_culturels" class="form-control" rows="4">{{ old('lieux_culturels', $auberge->lieux_culturels) }}</textarea>
        </div>

        <div class="form-group mt-3">
            <label for="autres_services" class="col-sm-6 col-form-label"> خدمات أخرى </label>
            <textarea name="autres_services" placeholder="أذكر الخدمات الإضافية إن وجدت..." id="autres_services" class="form-control" rows="4">{{ old('autres_services', $auberge->autres_services) }}</textarea>
        </div>

        <div class="text-center mt-4">
            <button type="submit" class="btn btn-success mx-2">
                <i class="la la-save"></i> حفظ التعديلات
            </button>

            <a href="{{ route('auberges.index') }}" class="btn btn-secondary mx-2">
                <i class="la la-arrow-right"></i> رجوع
            </a>
        </div>

    </form>
</div>

<script>
let restaurationIndex = {{ $index }}; // commence après le dernier index existant

function addRestaurationRow() {
    const tbody = document.getElementById('restauration-body');
    const tr = document.createElement('tr');

    tr.innerHTML = `
        <td><input type="text" name="restaurations[${restaurationIndex}][nom_ar]" class="form-control" placeholder="مثلاً: فطور الصباح" required></td>
        <td><input type="text" name="restaurations[${restaurationIndex}][nom_fr]" class="form-control" placeholder="Petit-déjeuner" required></td>
        <td><input type="text" name="restaurations[${restaurationIndex}][nom_en]" class="form-control" placeholder="Breakfast" required></td>
        <td><textarea name="restaurations[${restaurationIndex}][description_ar]" class="form-control" rows="1" placeholder="مكونات الفطور..."></textarea></td>
        <td><textarea name="restaurations[${restaurationIndex}][description_fr]" class="form-control" rows="1" placeholder="Description en français..."></textarea></td>
        <td><textarea name="restaurations[${restaurationIndex}][description_en]" class="form-control" rows="1" placeholder="Description in English..."></textarea></td>
        <td><input type="number" step="0.01" name="restaurations[${restaurationIndex}][tarif]" class="form-control" placeholder="0.00" required></td>
        <td class="action-buttons">
            <button type="button" class="btn btn-danger btn-sm" onclick="removeRestaurationRow(this)">حذف</button>
        </td>
    `;

    tbody.appendChild(tr);
    restaurationIndex++;
}

function removeRestaurationRow(button) {
    const row = button.closest('tr');
    row.remove();
}
</script>


@endsection

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
